"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const jsx_runtime_1 = require("react/jsx-runtime");
const GitGraph = ({ data }) => {
    if (!data) {
        return null;
    }
    const UNIT = 14;
    const MIN_WIDTH = 5 * UNIT;
    const HEIGHT = 22;
    const RADIUS = 4;
    const [commitPosition, commitColor, lines] = data;
    const commitX = (commitPosition + 1) * UNIT;
    const width = (Math.max(...mapLines(lines, ([top, bottom]) => Math.max(top, bottom)), commitPosition) +
        2) *
        UNIT;
    return ((0, jsx_runtime_1.jsxs)("svg", Object.assign({ width: Math.max(width, MIN_WIDTH), height: HEIGHT }, { children: [mapLines(lines, ([top, bottom, color], index) => {
                const topX = (top + 1) * UNIT;
                const bottomX = (bottom + 1) * UNIT;
                let points = `${topX},0 ${topX},4 ${bottomX},11 ${bottomX},${HEIGHT}`;
                if (top === -1 && bottom === -1) {
                    return null;
                }
                if (top === -1) {
                    points = `${commitX},11 ${bottomX},18 ${bottomX},${HEIGHT}`;
                }
                if (bottom === -1) {
                    points = `${topX},0 ${topX},4 ${commitX},11`;
                }
                if (top === -2 && bottom === -1) {
                    points = `${commitX},-11 ${commitX},11`;
                }
                return ((0, jsx_runtime_1.jsx)("polyline", { points: points, style: {
                        fill: "none",
                        stroke: color,
                        strokeWidth: 2,
                    } }, index));
            }), (0, jsx_runtime_1.jsx)("circle", { cx: commitX, cy: HEIGHT / 2, r: RADIUS, fill: commitColor, stroke: commitColor, strokeWidth: "2" })] })));
};
function mapLines(lines, handler) {
    const results = [];
    for (let i = 0; i < lines.length; i += 3) {
        results.push(handler([
            lines[i],
            lines[i + 1],
            lines[i + 2],
        ], i / 3));
    }
    return results;
}
exports.default = GitGraph;
//# sourceMappingURL=index.js.map